/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class CepInstanceEvent
extends IPCEvent {
    public EventType type;

    public CepInstanceEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        MESSAGE_RECEIVED,
        REMOTE_MESSAGE_RECEIVED;

    }

    public static class RemoteMessageReceived
    extends CepInstanceEvent {
        public String srcCepId;
        public UUID srcCepInstanceId;
        public String message;

        public RemoteMessageReceived(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.REMOTE_MESSAGE_RECEIVED;
            this.srcCepId = (String)ltv.getEventParameters().get(0);
            this.srcCepInstanceId = (UUID)ltv.getEventParameters().get(1);
            this.message = (String)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tsrcCepId = " + this.srcCepId + "\n\tsrcCepInstanceId = " + this.srcCepInstanceId + "\n\tmessage = " + this.message;
        }
    }

    public static class MessageReceived
    extends CepInstanceEvent {
        public String srcCepId;
        public UUID srcCepInstanceId;
        public String message;

        public MessageReceived(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MESSAGE_RECEIVED;
            this.srcCepId = (String)ltv.getEventParameters().get(0);
            this.srcCepInstanceId = (UUID)ltv.getEventParameters().get(1);
            this.message = (String)ltv.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tsrcCepId = " + this.srcCepId + "\n\tsrcCepInstanceId = " + this.srcCepInstanceId + "\n\tmessage = " + this.message;
        }
    }
}

